﻿using System;

namespace LFS_External
{
    public static class MathHelper
    {
        public static double SpeedToMps(int speed)
        {
            return speed / 327.68;
        }

        public static double SpeedToMph(int speed)
        {
            return speed / 91.02;
        }

        public static double SpeedToKph(int speed)
        {
            return speed / 91.02;
        }

        public static double MpsToMph(double mps)
        {
            return mps * 2.23;
        }

        public static double MpsToKph(double mps)
        {
            return mps * 3.6;
        }

        public static double MetersToMiles(double meters)
        {
            return meters / 1609.344;
        }

        public static double MetersToKilometers(double meters)
        {
            return meters / 1000.0;
        }

        public static double LengthToMetres(double length)
        {
            return length / 65536.0;
        }

        public static double RadiansToDegrees(double radians)
        {
            return radians * (180.0 / Math.PI);
        }

        public static double RadiansToRpm(double radians)
        {
            return radians * (60.0 / (2.0 * Math.PI));
        }

        public static double Distance(double aX, double aY, double aZ, double bX, double bY, double bZ)
        {
            return Math.Sqrt((bX - aX) * (bX - aX) + (bY - aY) * (bY - aY) + (bZ - aZ) * (bZ - aZ));
        }
    }
}
